/*
 *  libzplay - windows ( WIN32 ) multimedia library
 *
 *  ver: 2.00
 *  date: 22. April, 2010.
 *
 *  Copyright (C) 2003-2010 Zoran Cindori
 *
 *  Author: Zoran Cindori
 *  Web: http://libzplay.sourceforge.net/
 *  Email: zcindori@inet.hr
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 * Supported by:
 *
 * ============================================================================
 * libmad - MPEG audio decoder library
 * Copyright (C) 2000-2004 Underbit Technologies, Inc. <support@underbit.com>
 * http://www.underbit.com/products/mad/
 * GNU General Public License ( GPL.TXT )
 * ============================================================================
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002 
 * by the Xiph.Org Foundation http://www.xiph.org/
 * BSD-STYLE SOURCE LICENSE  ( XIPH.TXT )
 * ============================================================================
 * LIBA52
 * free library for decoding ATSC A/52 streams.
 * It is released under the terms of the GPL license.
 * ============================================================================
 * FLAC - Free Lossless Audio Codec
 * Copyright (C) 2001,2002,2003,2004,2005,2006,2007  Josh Coalson
 * http://flac.sourceforge.net/
 *
 * This file is part the FLAC project.  FLAC is comprised of several
 * components distributed under difference licenses.  The codec libraries
 * are distributed under Xiph.Org's BSD-like license (see the file
 * XIPH.TXT in this distribution).  All other programs, libraries, and
 * plugins are distributed under the LGPL or GPL (see LGPL.TXT and
 * GPL.TXT).  The documentation is distributed under the Gnu FDL (see
 * FDL.TXT).  Each file in the FLAC distribution contains at the top the
 * terms under which it may be distributed.
 *
 * Since this particular file is relevant to all components of FLAC,
 * it may be distributed under the Xiph.Org license, which is the least
 * restrictive of those mentioned above.  See the file XIPH.TXT in this
 * distribution.
 * ============================================================================
 * FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
 * Copyright (C) 2003-2005 M. Bakker, Nero AG, http://www.nero.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Any non-GPL usage of this software or parts of this software is strictly
 * forbidden.
 *
 * The "appropriate copyright message" mentioned in section 2c of the GPLv2
 * must read: "Code from FAAD2 is copyright (c) Nero AG, www.nero.com"
 *
 * Commercial non-GPL licensing of this software is possible.
 * For more info contact Nero AG through Mpeg4AAClicense@nero.com.
 *
 * ============================================================================
 * FAAC - Freeware Advanced Audio Coder Copyright (C) 2001 M. Bakker
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. 
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details. 
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *
 * ============================================================================
 * libmp3lame encoder
 * LAME 3.xx LAME Ain't an MP3 Encoder http://www.mp3dev.org March 2001 
 * 
 * Originally developed by Mike Cheng (www.uq.net.au/~zzmcheng).
 * Now maintained by Mark Taylor (www.mp3dev.org). 
 *
 * This code is distributed under the GNU LESSER PUBLIC LICENSE (LGPL, see www.gnu.org)
 * with the following modification: 
 * 
 * If you determine that distribution of LAME requires a patent license,
 * and you obtain a patent license, you may distribute LAME even though redistribution
 * of LAME may also require a patent license. 
 *
 * You agree not to enforce any patent claims for any aspect of MPEG audio compression,
 * or any other techniques contained in the LAME source code. 
 *
 * Copyrights (c) 1999-1007 by The LAME Project Copyrights (c) 1999,2000,2001
 * by Mark Taylor Copyrights (c) 1999,2000,2001 by Mark Taylor Copyrights
 * (c) 1998 by Michael Cheng Copyrights (c) 1995,1996,1997 by Michael Hipp: mpglib
 *
 * ============================================================================
 * SoundTouch library Copyright (c) Olli Parviainen 2002-2009 
 * http://www.surina.net/soundtouch
 * GNU Lesser General Public License vesrion 2.1 (LGPL.TXT )
 * ============================================================================
 * Center Cut DSP Plugin for Winamp 2.x 
 * Copyright (C) 2004  Moitah (moitah@yahoo.com)
 * GNU General Public License ( GPL.TXT )
 * ============================================================================
 * Shibatch Super Equalizer ver 0.03 for winamp
 * written by Naoki Shibata  shibatch@users.sourceforge.net
 * http://shibatch.sourceforge.net/
 *
 * Shibatch Super Equalizer (except FFT part) is distributed under LGPL.
 * See LGPL.txt for details.
 * FFT part is a routine made by Mr.Ooura. This routine is a freeware.
 * Contact Mr.Ooura for details of distributing licenses.
 * http://momonga.t.u-tokyo.ac.jp/~ooura/fft.html
 * ============================================================================
 * The Independent JPEG Group's JPEG software
 * JPEG decoding library
 * Copyright (C) 1991-2010, Thomas G. Lane, Guido Vollbeding.
 * www.ijg.org
 * ============================================================================
 * ZLIB DATA COMPRESSION LIBRARY
 * (C) 1995-2010 Jean-loup Gailly and Mark Adler
 * http://zlib.net/ 
 * ============================================================================
 * libpng library
 * PNG picture decoding library
 * Copyright (c) 2004, 2006-2007 Glenn Randers-Pehrson
 * http://www.libpng.org/
 * ============================================================================
*/

#ifndef _LIBZPLAY_H__
#define _LIBZPLAY_H__


/*
*	Define LIB_ZPLAY_STATIC to build static library.
*
*	Define LIB_ZPLAY_DYNAMIC to build dynamic library exporting functions with __declspec (dllexport)
*
*	Define LIB_ZPLAY_DYNAMIC and LIB_ZPLAY_EXPORT_WITH_DEF_FILE   to disable __declspec (dllexport)
*	so you can export functions with def file.
*
*	HOW TO USE THIS LIBRARY:
*
*	If there is nothing defined, functions are using __declspec (dllimport) and you need
*	dynamic version ( dll file ) of libzplay library.
*
*	Define LIB_ZPLAY_STATIC to disable __declspec (dllimport) and use library as static library.
*
*
*	By default, this library is configured to dynamicly link with your application using  __declspec (dllimport)
*
*	So, if you need to link with static version of this library define LIB_ZPLAY_STATIC
*
*/



#ifdef LIB_ZPLAY_STATIC
	#define W_DECLSPEC
#else	
	#ifdef LIB_ZPLAY_DYNAMIC
		#ifdef LIB_ZPLAY_EXPORT_WITH_DEF_FILE
			#define W_DECLSPEC
		#else
			#define W_DECLSPEC __declspec (dllexport)
		#endif
	#else
		#define W_DECLSPEC __declspec (dllimport)
	#endif
#endif


namespace libZPlay {


#define ZPLAY_HANDLE char*

enum TStreamFormat
{
		sfUnknown = 0,
		sfMp3 = 1,
		sfOgg = 2,
		sfWav = 3,
		sfPCM = 4,
		sfFLAC = 5,
		sfFLACOgg = 6,
		sfAC3 = 7,
		sfAacADTS = 8,
		sfWaveIn = 9,
		sfAutodetect = 1000
};


#define WaveOutWaveMapper 0xFFFFFFFF
#define WaveInWaveMapper 0xFFFFFFFF

enum TFFTGraphSize
{
	FFTGraphMinWidth = 100,
	FFTGraphMinHeight = 60
};


enum TBMPDetectionMethod
{
	dmPeaks = 0,
	dmAutoCorrelation = 1
};


enum TFFTGraphHorizontalScale
{
	gsLogarithmic = 0,
	gsLinear = 1
};


enum TSeekMethod
{
	smFromBeginning = 1,
	smFromEnd = 2,
	smFromCurrentForward = 4,
	smFromCurrentBackward = 8
};



enum TTimeFormat
{
	tfMillisecond = 1,
	tfSecond = 2,
	tfHMS = 4,
	tfSamples = 8
};

typedef struct {
	unsigned int hour;
	unsigned int minute;
	unsigned int second;
	unsigned int millisecond;
} TStreamHMSTime;


typedef struct {
	unsigned int sec;
	unsigned int ms;
	unsigned int samples;
	TStreamHMSTime hms;
} TStreamTime;


typedef struct {
	int nLeftDelay;	
	int nLeftSrcVolume;	
	int nLeftEchoVolume;
	int nRightDelay;
	int nRightSrcVolume;
	int nRightEchoVolume;
} TEchoEffect;


enum TWaveOutFormat
{
	format_invalid = 0,
	format_11khz_8bit_mono = 1,
	format_11khz_8bit_stereo = 2,
	format_11khz_16bit_mono = 4,
	format_11khz_16bit_stereo = 8,
	format_22khz_8bit_mono = 16,
	format_22khz_8bit_stereo = 32,
	format_22khz_16bit_mono = 64,
	format_22khz_16bit_stereo = 128,
	format_44khz_8bit_mono = 256,
	format_44khz_8bit_stereo = 512,
	format_44khz_16bit_mono = 1024,
	format_44khz_16bit_stereo = 2048
};


enum TWaveOutFunctionality
{
	supportPitchControl = 1,
	supportPlaybackRateControl = 2,
	supportVolumeControl = 4,
	supportSeparateLeftRightVolume = 8,
	supportSync = 16,
	supportSampleAccuratePosition = 32,
	supportDirectSound = 6
}; 


typedef struct {
	unsigned int ManufacturerID;
	unsigned int ProductID;
	unsigned int DriverVersion;
	unsigned int Formats;
	unsigned int Channels;
	unsigned int Support;
	char *ProductName;
} TWaveOutInfo;


typedef struct {
	unsigned int ManufacturerID;
	unsigned int ProductID;
	unsigned int DriverVersion;
	unsigned int Formats;
	unsigned int Channels;
	unsigned int Support;
	wchar_t *ProductName;
} TWaveOutInfoW;



typedef struct {
	unsigned int ManufacturerID;
	unsigned int ProductID;
	unsigned int DriverVersion;
	unsigned int Formats;
	unsigned int Channels;
	char *ProductName;
} TWaveInInfo;


typedef struct {
	unsigned int ManufacturerID;
	unsigned int ProductID;
	unsigned int DriverVersion;
	unsigned int Formats;
	unsigned int Channels;
	wchar_t *ProductName;
} TWaveInInfoW;



typedef struct {
	int fPlay;
	int fPause;
	int fEcho;
	int fEqualizer;	
	int fVocalCut;
	int fSideCut;
	int fChannelMix;
	int fSlideVolume;
	int nLoop;
	int fReverse;
	int nSongIndex;
	int nSongsInQueue;
} TStreamStatus;





enum TID3Version
{
	id3Version1 = 1,
	id3Version2 = 2
};



typedef struct {
	char *Title;
	char *Artist;
	char *Album;
	char *Year;
	char *Comment;
	char *TrackNum; 
	char *Genre;
} TID3Info;


typedef struct {
	unsigned int PicturePresent;
	unsigned int CanDrawPicture;
	char *MIMEType;
	int PictureType;
	char *Description;
	void *PictureData;
	unsigned int PictureDataSize;
	void *hBitmap;
	unsigned int Width;
	unsigned int Height;
	char reserved[128];
} TID3Picture;

typedef struct {
	unsigned int PicturePresent;
	unsigned int CanDrawPicture;
	wchar_t *MIMEType;
	int PictureType;
	wchar_t *Description;
	void *PictureData;
	unsigned int PictureDataSize;
	void *hBitmap;
	unsigned int Width;
	unsigned int Height;
	char reserved[128];
} TID3PictureW;

typedef struct {
	char *Title;
	char *Artist;
	char *Album;
	char *Year;
	char *Comment;
	char *TrackNum; 
	char *Genre;
	char *AlbumArtist;
	char *Composer;
	char *OriginalArtist;
	char *Copyright;
	char *URL;
	char *Encoder;
	char *Publisher;
	unsigned int BPM;
	TID3Picture Picture;
	char reserved[128];
} TID3InfoEx;

typedef struct {
	wchar_t *Title;
	wchar_t *Artist;
	wchar_t *Album;
	wchar_t *Year;
	wchar_t *Comment;
	wchar_t *TrackNum; 
	wchar_t *Genre;
	wchar_t *AlbumArtist;
	wchar_t *Composer;
	wchar_t *OriginalArtist;
	wchar_t *Copyright;
	wchar_t *URL;
	wchar_t *Encoder;
	wchar_t *Publisher;
	unsigned int BPM;
	TID3PictureW Picture;
	char reserved[128];
} TID3InfoExW;


typedef struct {
	wchar_t *Title;
	wchar_t *Artist;
	wchar_t *Album;
	wchar_t *Year;
	wchar_t *Comment;
	wchar_t *TrackNum; 
	wchar_t *Genre;
} TID3InfoW;



typedef struct {
	int SamplingRate;
	int ChannelNumber;
	int VBR;
	int Bitrate;
	TStreamTime Length;
	char *Description;
} TStreamInfo;


typedef struct {
	int SamplingRate;
	int ChannelNumber;
	int VBR;
	int Bitrate;
	TStreamTime Length;
	wchar_t *Description;
} TStreamInfoW;


typedef struct {
	unsigned int NumberOfBuffers;
	unsigned int NumberOfBytes;
} TStreamLoadInfo;


enum TFFTGraphType
{
	gtLinesLeftOnTop = 0,
	gtLinesRightOnTop,
	gtAreaLeftOnTop,
	gtAreaRightOnTop,
	gtBarsLeftOnTop,
	gtBarsRightOnTop,
	gtSpectrum
};


enum TFFTWindow
{
	fwRectangular = 1,
	fwHamming,
	fwHann,
	fwCosine,
	fwLanczos,
	fwBartlett,
	fwTriangular,
	fwGauss,
	fwBartlettHann,
	fwBlackman,
	fwNuttall,
	fwBlackmanHarris,
	fwBlackmanNuttall,
	fwFlatTop
};



enum TFFTGraphParamID
{
	gpFFTPoints = 1,
	gpGraphType,
	gpWindow,
	gpHorizontalScale,
	gpSubgrid,
	gpTransparency,
	gpFrequencyScaleVisible,
	gpDecibelScaleVisible,
	gpFrequencyGridVisible,
	gpDecibelGridVisible,
	gpBgBitmapVisible,
	gpBgBitmapHandle,
	gpColor1,
	gpColor2,
	gpColor3,
	gpColor4,
	gpColor5,
	gpColor6,
	gpColor7,
	gpColor8,
	gpColor9,
	gpColor10,
	gpColor11,
	gpColor12,
	gpColor13,
	gpColor14,
	gpColor15,
	gpColor16

};





enum  TCallbackMessage
{

	MsgStopAsync = 1,
	MsgPlayAsync = 2,
	MsgEnterLoopAsync = 4,
	MsgExitLoopAsync = 8,
	MsgEnterVolumeSlideAsync = 16,
	MsgExitVolumeSlideAsync = 32,
	MsgStreamBufferDoneAsync = 64,
	MsgStreamNeedMoreDataAsync = 128,
	MsgNextSongAsync = 256,
	MsgStop = 65536,
	MsgPlay = 131072,
	MsgEnterLoop = 262144,
	MsgExitLoop = 524288,
	MsgEnterVolumeSlide = 1048576,
	MsgExitVolumeSlide = 2097152,
	MsgStreamBufferDone = 4194304,
	MsgStreamNeedMoreData = 8388608,
	MsgNextSong = 16777216,
	MsgWaveBuffer = 33554432
};


typedef int  (__stdcall * TCallbackFunc)(void* instance, void *user_data, TCallbackMessage message, unsigned int param1, unsigned int param2);


enum TSettingID {
	sidWaveBufferSize = 1,
	sidAccurateLength = 2,
	sidAccurateSeek = 3,
	sidSamplerate = 4,
	sidChannelNumber = 5,
	sidBitPerSample = 6,
	sidBigEndian = 7,
	sidWaveInBufferSize = 8
};

// =============================================================================================================
//
//	INTERFACE FOR ZPlay CLASS
//
// =============================================================================================================

class ZPlay
{
	public:


virtual int __stdcall SetSettings(TSettingID nSettingID, int nValue) = 0;
virtual int __stdcall GetSettings(TSettingID nSettingID) = 0;
virtual int __stdcall GetVersion() = 0;
virtual char * __stdcall GetError() = 0;	
virtual wchar_t * __stdcall GetErrorW() = 0;
virtual TStreamFormat __stdcall GetFileFormat(const char *pchFileName) = 0;	
virtual TStreamFormat __stdcall GetFileFormatW(const wchar_t *pchFileName) = 0;
virtual int __stdcall EnumerateWaveOut() = 0;
virtual int __stdcall GetWaveOutInfo(unsigned int nIndex, TWaveOutInfo *pWaveOutInfo) = 0;
virtual int __stdcall GetWaveOutInfoW(unsigned int nIndex, TWaveOutInfoW *pWaveOutInfo) = 0;
virtual int __stdcall SetWaveOutDevice(unsigned int nIndex) = 0;
virtual int __stdcall OpenFile(const char *sFileName, TStreamFormat nFormat)= 0;	
virtual int __stdcall OpenFileW(const wchar_t *sFileName, TStreamFormat nFormat)= 0;		
virtual int __stdcall AddFile(const char *sFileName, TStreamFormat nFormat)= 0;
virtual int __stdcall AddFileW(const wchar_t *sFileName, TStreamFormat nFormat)= 0;
virtual int __stdcall OpenStream(int fBuffered, int fDynamic, const void *sMemStream, unsigned int nStreamSize, TStreamFormat nFormat) = 0;
virtual int __stdcall PushDataToStream(const void *sMemNewData, unsigned int nNewDataize) = 0;
virtual int __stdcall IsStreamDataFree(const void *sMemNewData) = 0;
virtual void __stdcall GetDynamicStreamLoad(TStreamLoadInfo *pStreamLoadInfo) = 0;
virtual void __stdcall GetStreamInfo(TStreamInfo *pInfo) = 0;
virtual void __stdcall GetStreamInfoW(TStreamInfoW *pInfo) = 0;
virtual int __stdcall Close() = 0;
virtual int __stdcall Play() = 0;
virtual int __stdcall PlayLoop(TTimeFormat fFormatStartTime, TStreamTime *pStartTime, TTimeFormat fFormatEndTime, TStreamTime *pEndTime, unsigned int nNumOfCycles, unsigned int fContinuePlaying) = 0;
virtual int __stdcall Seek(TTimeFormat fFormat, TStreamTime *pTime, TSeekMethod nMoveMethod) = 0;
virtual int __stdcall ReverseMode(int fEnable) = 0;
virtual int __stdcall Stop() = 0;
virtual int __stdcall Pause() = 0;
virtual int __stdcall Resume() = 0;
virtual void __stdcall GetPosition(TStreamTime *pTime) = 0;
virtual int __stdcall SetMasterVolume(unsigned int nLeftVolume, unsigned int nRightVolume) = 0;
virtual int __stdcall SetPlayerVolume(unsigned int nLeftVolume, unsigned int nRightVolume) = 0;
virtual void __stdcall GetMasterVolume(unsigned int *pnLeftVolume, unsigned int *pnRightVolume) = 0;
virtual void __stdcall GetPlayerVolume(unsigned int *pnLeftVolume,unsigned int *pnRightVolume) = 0;
virtual int __stdcall GetBitrate(int fAverage) = 0;
virtual void __stdcall GetStatus(TStreamStatus *pStatus) = 0;
virtual int __stdcall MixChannels(int fEnable, unsigned int nLeftPercent, unsigned int nRightPercent) = 0;
virtual void __stdcall GetVUData(unsigned int *pnLeftChannel, unsigned int *pnRightChannel) = 0;
virtual int __stdcall SlideVolume(int fFormatStart, TStreamTime *pTimeStart, unsigned int nStartVolumeLeft, unsigned int nStartVolumeRight, int fFormatEnd, TStreamTime *pTimeEnd, unsigned int nEndVolumeLeft,unsigned int nEndVolumeRight) = 0;
virtual int __stdcall EnableEqualizer(int fEnable) = 0;
virtual int __stdcall SetEqualizerPoints(int *pnFreqPoint, int nNumOfPoints) = 0;
virtual int __stdcall GetEqualizerPoints(int *pnFreqPoint, int nFreqPointNumber) = 0;
virtual int __stdcall SetEqualizerParam(int nPreAmpGain, int *pnBandGain, int nNumberOfBands) = 0;
virtual int __stdcall GetEqualizerParam(int *pnPreAmpGain, int *pnBandGain,	int nNumberOfBands) = 0;
virtual int __stdcall SetEqualizerPreampGain(int nGain) = 0;
virtual int __stdcall GetEqualizerPreampGain() = 0; 
virtual int __stdcall SetEqualizerBandGain(int nBandIndex, int nGain) = 0;
virtual int __stdcall GetEqualizerBandGain(int nBandIndex) = 0;
virtual int __stdcall LoadID3(TID3Version nId3Version, TID3Info *pId3Info) = 0;
virtual int __stdcall LoadID3W(TID3Version nId3Version,	TID3InfoW *pId3Info) = 0;
virtual int __stdcall LoadFileID3(const char *pchFileName, TStreamFormat nFormat, TID3Version nId3Version, TID3Info *pId3Info) = 0;
virtual int __stdcall LoadFileID3W(const wchar_t *pchFileName, TStreamFormat nFormat, TID3Version nId3Version, TID3InfoW *pId3Info) = 0;
virtual int __stdcall EnableEcho(int fEnable) = 0;
virtual int __stdcall SetEchoParam(TEchoEffect *pEchoEffect, int nNumberOfEffects) = 0;
virtual int __stdcall GetEchoParam(TEchoEffect *pEchoEffect, int nNumberOfEffects) = 0;
virtual int __stdcall SetCallbackFunc(TCallbackFunc pCallbackFunc,TCallbackMessage nMessages, void *user_data) = 0;
virtual int __stdcall SetRate(unsigned int nRate)= 0;
virtual unsigned int __stdcall GetRate()= 0;
virtual int __stdcall SetPitch(unsigned int nPitch)= 0;
virtual unsigned int __stdcall GetPitch()= 0;
virtual int __stdcall SetTempo(unsigned int nTempo)= 0;
virtual unsigned int __stdcall GetTempo()= 0;
virtual int __stdcall StereoCut(int fEnable, int fOutputCenter, int fBassToSides)= 0;
virtual void __stdcall Release() = 0;
virtual int __stdcall DetectBPM(TBMPDetectionMethod nMethod) = 0;
virtual int __stdcall DetectFileBPM(const char *pchFileName, TStreamFormat nFormat, TBMPDetectionMethod nMethod)= 0;
virtual int __stdcall DetectFileBPMW(const wchar_t *pchFileName, TStreamFormat nFormat, TBMPDetectionMethod nMethod)= 0;
virtual int __stdcall GetFFTData(int nFFTPoints, TFFTWindow nFFTWindow, int *pnHarmonicNumber,int *pnHarmonicFreq,int *pnLeftAmplitude,int *pnRightAmplitude,int *pnLeftPhase,int *pnRightPhase) = 0;
virtual int __stdcall DrawFFTGraphOnHDC(void* hdc, int nX, int nY, int nWidth, int nHeight) = 0;
virtual int __stdcall DrawFFTGraphOnHWND(void* hwnd, int nX, int nY, int nWidth, int nHeight) = 0;
virtual int __stdcall SetFFTGraphParam(TFFTGraphParamID nParamID, int nValue) = 0;
virtual int __stdcall GetFFTGraphParam(TFFTGraphParamID nParamID) = 0;

// new inferface in ver. 2.0  - 23.04.2010.
virtual int __stdcall LoadID3Ex(TID3InfoEx *pId3Info, unsigned int fDecodeEmbededPicture) = 0;
virtual int __stdcall LoadID3ExW(TID3InfoExW *pId3Info, unsigned int fDecodeEmbededPicture) = 0;
virtual int __stdcall LoadFileID3Ex(const char *pchFileName, TStreamFormat nFormat, TID3InfoEx *pId3Info, unsigned int fDecodeEmbededPicture) = 0;
virtual int __stdcall LoadFileID3ExW(const wchar_t *pchFileName, TStreamFormat nFormat, TID3InfoExW *pId3Info, unsigned int fDecodeEmbededPicture) = 0;
virtual int __stdcall DrawBitmapToHDC(void *hdc, int X, int Y, int Width, int Height, void *hBitmap) = 0;
virtual int __stdcall DrawBitmapToHWND(void *hwnd, int X, int Y, int Width, int Height, void *hBitmap) = 0;
virtual int __stdcall EnumerateWaveIn() = 0;
virtual int __stdcall GetWaveInInfo(unsigned int nIndex, TWaveInInfo *pWaveInInfo) = 0;
virtual int __stdcall GetWaveInInfoW(unsigned int nIndex, TWaveInInfoW *pWaveInInfo) = 0;
virtual int __stdcall SetWaveInDevice(unsigned int nIndex) = 0;
virtual int __stdcall SetWaveOutFile(const char *sFileName, TStreamFormat nFormat, unsigned int fOutputToSoundcard)= 0;
virtual int __stdcall SetWaveOutFileW(const wchar_t *sFileName, TStreamFormat nFormat, unsigned int fOutputToSoundcard)= 0;

};




// =============================================================================================================
//
//	END OF INTERFACE FOR ZPlay CLASS
//
// =============================================================================================================


#ifdef __cplusplus
extern "C" {
#endif

// =============================================================================================================
//
//	CLASS FACTORY FOR ZPlay INTERFACE
//
// =============================================================================================================


W_DECLSPEC  ZPlay *  __stdcall CreateZPlay(); 


// =============================================================================================================
//
//	END OF CLASS FACTORY FOR ZPLAY INTERFACE
//
// =============================================================================================================


// =============================================================================================================
//
//	C WRAPPER FOR ZPlay CLASS
//
// =============================================================================================================

W_DECLSPEC ZPLAY_HANDLE __stdcall zplay_CreateZPlay(); 
W_DECLSPEC int __stdcall zplay_DestroyZPlay(ZPLAY_HANDLE handle); 
W_DECLSPEC int __stdcall zplay_GetVersion(ZPLAY_HANDLE handle);
W_DECLSPEC char * __stdcall zplay_GetError(ZPLAY_HANDLE handle);				
W_DECLSPEC wchar_t * __stdcall zplay_GetErrorW(ZPLAY_HANDLE handle);
W_DECLSPEC TStreamFormat __stdcall zplay_GetFileFormat(ZPLAY_HANDLE handle, const char *pchFileName);
W_DECLSPEC TStreamFormat __stdcall zplay_GetFileFormatW(ZPLAY_HANDLE handle, const wchar_t *pchFileName);
W_DECLSPEC int __stdcall zplay_EnumerateWaveOut(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_GetWaveOutInfo(ZPLAY_HANDLE handle, unsigned int nIndex,	TWaveOutInfo *pWaveOutInfo);
W_DECLSPEC int __stdcall zplay_GetWaveOutInfoW(ZPLAY_HANDLE handle,unsigned int nIndex,	TWaveOutInfoW *pWaveOutInfo);
W_DECLSPEC int __stdcall zplay_SetWaveOutDevice(ZPLAY_HANDLE handle, unsigned int nIndex);
W_DECLSPEC int __stdcall zplay_OpenFile(ZPLAY_HANDLE handle, const char *sFileName, TStreamFormat nFormat);
W_DECLSPEC int __stdcall zplay_OpenFileW(ZPLAY_HANDLE handle, const wchar_t *sFileName, TStreamFormat nFormat);	
W_DECLSPEC int __stdcall zplay_AddFile(ZPLAY_HANDLE handle, const char *sFileName, TStreamFormat nFormat);
W_DECLSPEC int __stdcall zplay_AddFileW(ZPLAY_HANDLE handle, const wchar_t *sFileName, TStreamFormat nFormat);
W_DECLSPEC int __stdcall zplay_OpenStream(ZPLAY_HANDLE handle, int fBuffered, int fManaged, const void *sMemStream, unsigned int nStreamSize, TStreamFormat nFormat);
W_DECLSPEC int __stdcall zplay_PushDataToStream(ZPLAY_HANDLE handle, const void *sMemNewData, unsigned int nNewDataize);
W_DECLSPEC int __stdcall zplay_IsStreamDataFree(ZPLAY_HANDLE handle, const void *sMemNewData);
W_DECLSPEC void __stdcall zplay_GetDynamicStreamLoad(ZPLAY_HANDLE handle,TStreamLoadInfo *pStreamLoadInfo);
W_DECLSPEC void __stdcall zplay_GetStreamInfo(ZPLAY_HANDLE handle,	TStreamInfo *pInfo);
W_DECLSPEC void __stdcall zplay_GetStreamInfoW(ZPLAY_HANDLE handle, TStreamInfoW *pInfo);
W_DECLSPEC int __stdcall zplay_Close(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_Play(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_PlayLoop(ZPLAY_HANDLE handle, TTimeFormat fFormatStartTime, TStreamTime *pStartTime, TTimeFormat fFormatEndTime, TStreamTime *pEndTime,	unsigned int nNumOfCycles, unsigned int fContinuePlaying);
W_DECLSPEC int __stdcall zplay_Seek(ZPLAY_HANDLE handle, TTimeFormat fFormat, TStreamTime *pTime, TSeekMethod nMoveMethod);
W_DECLSPEC int __stdcall zplay_ReverseMode(ZPLAY_HANDLE handle, int fEnable);
W_DECLSPEC int __stdcall zplay_Stop(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_Pause(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_Resume(ZPLAY_HANDLE handle);
W_DECLSPEC void __stdcall zplay_GetPosition(ZPLAY_HANDLE handle, TStreamTime *pTime);
W_DECLSPEC int __stdcall zplay_SetMasterVolume(ZPLAY_HANDLE handle, unsigned int nLeftVolume, unsigned int nRightVolume);
W_DECLSPEC int __stdcall zplay_SetPlayerVolume(ZPLAY_HANDLE handle, unsigned int nLeftVolume, unsigned int nRightVolume);
W_DECLSPEC void __stdcall zplay_GetMasterVolume(ZPLAY_HANDLE handle, unsigned int *pnLeftVolume, unsigned int *pnRightVolume);
W_DECLSPEC void __stdcall zplay_GetPlayerVolume(ZPLAY_HANDLE handle, unsigned int *pnLeftVolume, unsigned int *pnRightVolume);
W_DECLSPEC int __stdcall zplay_GetBitrate(ZPLAY_HANDLE handle, int fAverage);
W_DECLSPEC void __stdcall zplay_GetStatus(ZPLAY_HANDLE handle, TStreamStatus *pStatus);
W_DECLSPEC int __stdcall zplay_MixChannels(ZPLAY_HANDLE handle, int fEnable, unsigned int nLeftPercent, unsigned int nRightPercent);	
W_DECLSPEC void __stdcall zplay_GetVUData(ZPLAY_HANDLE handle, unsigned int *pnLeftChannel,unsigned int *pnRightChannel);
W_DECLSPEC int __stdcall zplay_SlideVolume(ZPLAY_HANDLE handle, int fFormatStart, TStreamTime *pTimeStart, unsigned int nStartVolumeLeft, unsigned int nStartVolumeRight, int fFormatEnd, TStreamTime *pTimeEnd, unsigned int nEndVolumeLeft, unsigned int nEndVolumeRight);
W_DECLSPEC int __stdcall zplay_EnableEqualizer(ZPLAY_HANDLE handle, int fEnable);
W_DECLSPEC int __stdcall zplay_SetEqualizerPoints(ZPLAY_HANDLE handle, int *pnFreqPoint, int nNumOfPoints);
W_DECLSPEC int __stdcall zplay_GetEqualizerPoints(ZPLAY_HANDLE handle, int *pnFreqPoint, int nFreqPointNumber);
W_DECLSPEC int __stdcall zplay_SetEqualizerParam(ZPLAY_HANDLE handle, int nPreAmpGain, int *pnBandGain,	int nNumberOfBands);
W_DECLSPEC int __stdcall zplay_GetEqualizerParam(ZPLAY_HANDLE handle, int *pnPreAmpGain, int *pnBandGain, int nNumberOfBands);
W_DECLSPEC int __stdcall zplay_LoadID3(ZPLAY_HANDLE handle, TID3Version nId3Version, TID3Info *pId3Info);
W_DECLSPEC int __stdcall zplay_LoadID3W(ZPLAY_HANDLE handle, TID3Version nId3Version, TID3InfoW *pId3Info);
W_DECLSPEC int __stdcall zplay_LoadFileID3(ZPLAY_HANDLE handle, const char *pchFileName, TStreamFormat nFormat, TID3Version nId3Version, TID3Info *pId3Info);
W_DECLSPEC int __stdcall zplay_LoadFileID3W(ZPLAY_HANDLE handle, const wchar_t *pchFileName, TStreamFormat nFormat, TID3Version nId3Version, TID3InfoW *pId3Info);
W_DECLSPEC int __stdcall zplay_EnableEcho(ZPLAY_HANDLE handle,int fEnable);
W_DECLSPEC int __stdcall zplay_SetEchoParam(ZPLAY_HANDLE handle, TEchoEffect *pEchoEffect, int nNumberOfEffects);
W_DECLSPEC int __stdcall zplay_GetEchoParam(ZPLAY_HANDLE handle, TEchoEffect *pEchoEffectm, int nNumberOfEffects);
W_DECLSPEC int __stdcall zplay_SetCallbackFunc(ZPLAY_HANDLE handle, TCallbackFunc pCallbackFunc, TCallbackMessage nMessages, void *user_data);
W_DECLSPEC int __stdcall zplay_GetFFTData(
			ZPLAY_HANDLE handle,
			int nFFTPoints,
			TFFTWindow nFFTWindow,
			int *pnHarmonicNumber,
			int *pnHarmonicFreq,
			int *pnLeftAmplitude,
			int *pnRightAmplitude,
			int *pnLeftPhase,
			int *pnRightPhase
		);  	
W_DECLSPEC int __stdcall zplay_SetRate(ZPLAY_HANDLE handle, unsigned int nRate);
W_DECLSPEC unsigned int __stdcall zplay_GetRate(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_SetPitch(ZPLAY_HANDLE handle, unsigned int nPitch);
W_DECLSPEC unsigned int __stdcall zplay_GetPitch(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_SetTempo(ZPLAY_HANDLE handle, unsigned int nTempo);
W_DECLSPEC unsigned int __stdcall zplay_GetTempo(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_StereoCut(ZPLAY_HANDLE handle, int fEnable, int fOutputCenter, int fBassToSides);
W_DECLSPEC int __stdcall zplay_DrawFFTGraphOnHDC(ZPLAY_HANDLE handle, void* hdc, int nX, int nY, int nWidth, int nHeight);
W_DECLSPEC int __stdcall zplay_DrawFFTGraphOnHWND(ZPLAY_HANDLE handle, void* hwnd, int nX, int nY, int nWidth, int nHeight);
W_DECLSPEC int __stdcall zplay_SetFFTGraphParam(ZPLAY_HANDLE handle, TFFTGraphParamID nParamID, int nParamValue);
W_DECLSPEC int __stdcall zplay_GetFFTGraphParam(ZPLAY_HANDLE handle, TFFTGraphParamID nParamID);
W_DECLSPEC int __stdcall zplay_DetectBPM(ZPLAY_HANDLE handle, TBMPDetectionMethod nMethod);
W_DECLSPEC int __stdcall zplay_DetectFileBPM(ZPLAY_HANDLE handle, const char *pchFileName, TStreamFormat nFormat, TBMPDetectionMethod nMethod);
W_DECLSPEC int __stdcall zplay_DetectFileBPMW(ZPLAY_HANDLE handle, const wchar_t *pchFileName, TStreamFormat nFormat, TBMPDetectionMethod nMethod);
W_DECLSPEC int __stdcall zplay_SetEqualizerPreampGain(ZPLAY_HANDLE handle, int nGain);
W_DECLSPEC int __stdcall zplay_GetEqualizerPreampGain(ZPLAY_HANDLE handle);
W_DECLSPEC int __stdcall zplay_SetEqualizerBandGain(ZPLAY_HANDLE handle, int nBandIndex, int nGain);
W_DECLSPEC int __stdcall zplay_GetEqualizerBandGain(ZPLAY_HANDLE handle, int nBandIndex);
W_DECLSPEC int __stdcall zplay_SetSettings(ZPLAY_HANDLE handle, TSettingID nSettingID, int nValue);
W_DECLSPEC int __stdcall zplay_GetSettings(ZPLAY_HANDLE handle, TSettingID nSettingID);
W_DECLSPEC unsigned int __stdcall zplay_strlen(const char *s);
W_DECLSPEC unsigned int __stdcall zplay_wcslen(const wchar_t *s);
W_DECLSPEC void __stdcall zplay_memcpy(void *dest, const void *src, unsigned int n);
W_DECLSPEC void __stdcall zplay_memmove(void *dest, const void *src, unsigned int n);
W_DECLSPEC char * __stdcall zplay_strcpy(char *dest, const char *src);
W_DECLSPEC wchar_t * __stdcall zplay_wcscpy(wchar_t *dest, const wchar_t *src);
W_DECLSPEC void * __stdcall zplay_memset(void *s, int c, unsigned int n);

// new interface in ver. 2.0   - 23.04.2010.
W_DECLSPEC int __stdcall zplay_LoadID3Ex(ZPLAY_HANDLE handle, TID3InfoEx *pId3Info, unsigned int fDecodeEmbededPicture);
W_DECLSPEC int __stdcall zplay_LoadID3ExW(ZPLAY_HANDLE handle, TID3InfoExW *pId3Info, unsigned int fDecodeEmbededPicture);
W_DECLSPEC int __stdcall zplay_LoadFileID3Ex(ZPLAY_HANDLE handle, const char *pchFileName, TStreamFormat nFormat, TID3InfoEx *pId3Info, unsigned int fDecodeEmbededPicture);
W_DECLSPEC int __stdcall zplay_LoadFileID3ExW(ZPLAY_HANDLE handle, const wchar_t *pchFileName, TStreamFormat nFormat, TID3InfoExW *pId3Info, unsigned int fDecodeEmbededPicture);
W_DECLSPEC int __stdcall zplay_DrawBitmapToHDC(ZPLAY_HANDLE handle, void *hdc, int X, int Y, int Width, int Height, void *hBitmap);
W_DECLSPEC int __stdcall zplay_DrawBitmapToHWND(ZPLAY_HANDLE handle, void *hwnd, int X, int Y, int Width, int Height, void *hBitmap);

W_DECLSPEC  int __stdcall zplay_EnumerateWaveIn(ZPLAY_HANDLE handle);
W_DECLSPEC  int __stdcall zplay_GetWaveInInfo(ZPLAY_HANDLE handle, unsigned int nIndex, TWaveInInfo *pWaveInInfo);
W_DECLSPEC  int __stdcall zplay_GetWaveInInfoW(ZPLAY_HANDLE handle, unsigned int nIndex, TWaveInInfoW *pWaveInInfo);
W_DECLSPEC  int __stdcall zplay_SetWaveInDevice(ZPLAY_HANDLE handle, unsigned int nIndex);

W_DECLSPEC int __stdcall zplay_SetWaveOutFile(ZPLAY_HANDLE handle, const char *sFileName, TStreamFormat nFormat, unsigned int fOutputToSoundcard);
W_DECLSPEC int __stdcall zplay_SetWaveOutFileW(ZPLAY_HANDLE handle, const wchar_t *sFileName, TStreamFormat nFormat, unsigned int fOutputToSoundcard);


// =============================================================================================================

#ifdef __cplusplus
}
#endif

}

#endif


